<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');

$routes->group('api', function ($routes) {

    $routes->group('v1', function ($routes) {
        // $routes->post('login', 'Api\V1\AuthenticationController::login');
        // $routes->get('logout', 'Api\V1\AuthenticationController::logout');

        $routes->get('login', 'Api\V1\AuthRegisterController::registerOrLogin');

        $routes->group('user', function ($routes) {
            $routes->get('detail', 'Api\V1\AuthenticationController::loggedInUserId');
        });


        $routes->group('doctor', function ($routes) {
            $routes->get('list', 'Api\V1\DoctorProfileController::doctorList');
            $routes->get('view', 'Api\V1\DoctorProfileController::viewDoctorProfile');
        });

        $routes->group('package', function ($routes) {
            $routes->get('list', 'Api\V1\PackagesController::packages');
            $routes->get('view', 'Api\V1\PackagesController::view');
        });

        $routes->group('js', function ($routes) {
            $routes->post('debit-inquery', 'Api\V1\JsPaymentController::debitInquery');
            $routes->post('debit-payment', 'Api\V1\JsPaymentController::debitPayments');
            $routes->post('make-payment', 'Api\V1\JsPaymentController::makePayment');
            $routes->post('verify', 'Api\V1\JsPaymentController::verify');
            $routes->post('reset', 'Api\V1\JsPaymentController::resetSecret');
        });

        $routes->group('agora', function ($routes) {
            $routes->get('token', 'Api\V1\AgoraTokenController::generateToken');
        });

        $routes->group('disease', function ($routes) {
            $routes->get('list', 'Api\V1\DiseasesController::list');
        });

        $routes->group('prescription', function ($routes) {
            $routes->get('view', 'Api\V1\PrescribeDetialsController::view');
            $routes->get('list', 'Api\V1\PrescribeDetialsController::list');
        });

        $routes->group('patient/disease', function ($routes) {
            $routes->get('list', 'Api\V1\PatientDiseasesController::list');
            $routes->post('save', 'Api\V1\PatientDiseasesController::save');
        });
    });
});
