<?php

namespace App\Controllers\Api\V1;

use Exception;
use App\Controllers\BaseController;
use App\Models\DiseasesModel;
use CodeIgniter\HTTP\ResponseInterface;

class DiseasesController extends BaseController
{
    protected  $diseasesModel;
    public function __construct()
    {
        $this->diseasesModel = new DiseasesModel();
    }

    public function list()
    {
        try {
            $result = $this->diseasesModel->findAll();
            return $this
                ->getApiResponse(
                    [
                        'statusCode' => 1,
                        'message' => "Disease information has been fetched successfully.",
                        'data' => $result,
                    ]
                );
        } catch (Exception $e) {
            return $this->getApiResponse(
                [
                    'statusCode' => 3,
                    'message' => $e->getMessage()
                ],
            );
        }
    }
}
