<?php

namespace App\Controllers\Api\V1;

use Exception;
use App\Controllers\BaseController;
use App\Models\PatientDiseasesModel;
use CodeIgniter\HTTP\ResponseInterface;

class PatientDiseasesController extends BaseController
{
    protected  $patientDiseasesModel;
    public function __construct()
    {
        $this->patientDiseasesModel = new PatientDiseasesModel();
    }

    public function save()
    {
        try {
            $rules = [
                'PatientProfileId' => 'required',
                // 'DiseaseListid.*' => 'required',
            ];
            $errors = [
                'PatientProfileId' => [
                    'required' => 'Patient profile id field is required.',
                ],
                // 'DiseaseListid.*' => [
                //     'required' => 'Disease list id field is required.',
                // ],
            ];

            $input = $this->getApiRequestInput($this->request);

            if (!$this->validateApiRequest($input, $rules, $errors)) {
                return $this
                    ->getApiResponse(
                        [
                            'statusCode' => 3,
                            'message' => array_values($this->validator->getErrors()),
                        ],
                        ResponseInterface::HTTP_OK
                    );
            }

            $patientProfileId = $input['PatientProfileId'];
            $diseases = $input['DiseaseListid'];
            $this->patientDiseasesModel->where('PatientProfileId', $patientProfileId)->delete();
            $data = [];
            foreach ($diseases as $disease) {
                if ($disease['isChecked'] === 'Yes') {
                    $data[] = [
                        'PatientProfileId' => $patientProfileId,
                        'DiseaseListid' => $disease['id']
                    ];
                }
            }
            $this->patientDiseasesModel->insertBatch($data);
            return $this
                ->getApiResponse(
                    [
                        'statusCode' => 1,
                        'message' => 'User has been registerd successfully.',
                        'data' => $data,
                    ]
                );
        } catch (Exception $e) {
            return $this->getApiResponse(
                [
                    'statusCode' => 3,
                    'message' => $e->getMessage()
                ],
            );
        }
    }

    public function list()
    {
        try {
            $rules = [
                'PatientProfileId' => 'required',
            ];
            $errors = [
                'PatientProfileId' => [
                    'required' => 'Patient Profile Id can not be empty.',
                ],
            ];
            $input = $this->getApiGetRequestInput($this->request);
            if (!$this->validateApiRequest($input, $rules, $errors)) {
                return $this
                    ->getApiResponse(
                        [
                            'statusCode' => 3,
                            'message' => array_values($this->validator->getErrors()),
                        ],
                    );
            }
            // $builder = $this->webdocdb->table('PatientDiseases as PD')
            //     ->select('PD.*, DL.Disease')
            //     ->join('DiseaseLists as DL', 'PD.DiseaseListid = DL.Id', 'Left')
            //     ->where('PatientProfileId', $input['PatientProfileId'])
            //     ->get();
            // $result = $builder->getResultArray();

            $builder = $this->webdocdb->table('DiseaseLists as DL')
                ->select('DL.*, PD.PatientProfileId AS PatientProfileId')
                ->select('(CASE WHEN PD.DiseaseListid IS NOT NULL THEN 1 ELSE 0 END) AS IsMatched', false)
                ->join('PatientDiseases as PD', 'PD.DiseaseListid = DL.Id AND PD.PatientProfileId = ' . $this->webdocdb->escape($input['PatientProfileId']), 'LEFT')
                ->get();
            $result = $builder->getResultArray();
            return $this
                ->getApiResponse(
                    [
                        'statusCode' => 1,
                        'message' => "Patient disease information has been fetched successfully.",
                        'data' => $result,
                    ]
                );
        } catch (Exception $e) {
            return $this->getApiResponse(
                [
                    'statusCode' => 3,
                    'message' => $e->getMessage()
                ],
            );
        }
    }
}
