<?php

namespace App\Controllers\Api\V1;

use Exception;
use App\Models\ConsultationsModel;
use App\Controllers\BaseController;
use App\Models\PrescribeDetialsModel;
use CodeIgniter\HTTP\ResponseInterface;

class PrescribeDetialsController extends BaseController
{
    protected  $consultationsModel;
    protected  $prescribeDetialsModel;
    public function __construct()
    {
        $this->consultationsModel = new ConsultationsModel();
        $this->prescribeDetialsModel = new PrescribeDetialsModel();
    }

    public function view()
    {
        try {
            $rules = [
                'consultationId' => 'required',
            ];
            $errors = [
                'consultationId' => [
                    'required' => 'Consultation id can not be empty.',
                ],
            ];
            $input = $this->getApiGetRequestInput($this->request);
            if (!$this->validateApiRequest($input, $rules, $errors)) {
                return $this
                    ->getApiResponse(
                        [
                            'statusCode' => 3,
                            'message' => array_values($this->validator->getErrors()),
                        ],
                    );
            }

            $consultation = $this->consultationsModel
                ->select('consultations.Id, consultations.ConsultationDate, consultations.Complaint, consultations.Diagnosis, consultations.Prescription, consultations.Tests, consultations.Remarks, P.FirstName as DoctorFirstName, P.LastName as DoctorLastName')
                ->join('DoctorProfiles as P', 'consultations.DoctorId = P.ApplicationUserId', 'left')
                ->where('consultations.Id', $input['consultationId'])
                ->orderBy('consultations.ConsultationDate', 'desc')
                ->first();

            $consultation['ConsultationDate'] = date('n/j/Y h:i:s A', strtotime($consultation['ConsultationDate']));
            $consultation['DoctorFullName'] = $consultation['DoctorFirstName'] . ' ' . $consultation['DoctorLastName'];
            $consultation['Consultationdetails'] = $this->prescribeDetialsModel->select('PrescribeDetials.*, MedicineNames.MedicineName')
                ->join('MedicineNames', 'PrescribeDetials.MedicineNameId = MedicineNames.id', 'left')
                ->where('PrescribeDetials.ConsultationId', $consultation['Id'])
                ->findAll();

            if (!empty($consultation)) {
                return $this
                    ->getApiResponse(
                        [
                            'statusCode' => 1,
                            'message' => "Prescription information has been fetched successfully.",
                            'data' => $consultation,
                        ]
                    );
            } else {
                return $this
                    ->getApiResponse(
                        [
                            'statusCode' => 1,
                            'message' => "There is no data.",
                        ]
                    );
            }
        } catch (Exception $e) {
            return $this->getApiResponse(
                [
                    'statusCode' => 3,
                    'message' => $e->getMessage()
                ],
            );
        }
    }

    public function list()
    {
        try {
            $rules = [
                'patientId' => 'required',
            ];
            $errors = [
                'patientId' => [
                    'required' => 'Patient id can not be empty.',
                ],
            ];
            $input = $this->getApiGetRequestInput($this->request);
            if (!$this->validateApiRequest($input, $rules, $errors)) {
                return $this
                    ->getApiResponse(
                        [
                            'statusCode' => 3,
                            'message' => array_values($this->validator->getErrors()),
                        ],
                    );
            }

            $consultation = $this->consultationsModel
                ->select('consultations.Id, consultations.ConsultationDate, consultations.Complaint, consultations.Diagnosis, consultations.Prescription, consultations.Tests, consultations.Remarks, P.FirstName as DoctorFirstName, P.LastName as DoctorLastName')
                ->join('DoctorProfiles as P', 'consultations.DoctorId = P.ApplicationUserId', 'left')
                ->where('consultations.PatientId', $input['patientId'])
                ->orderBy('consultations.ConsultationDate', 'desc')
                ->findAll();
            foreach ($consultation as $ckey => $consult) {
                $consultation[$ckey]['ConsultationDate'] = date('n/j/Y h:i:s A', strtotime($consult['ConsultationDate']));
                $consultation[$ckey]['DoctorFullName'] = $consult['DoctorFirstName'] . ' ' . $consult['DoctorLastName'];
                $consultation[$ckey]['Consultationdetails'] = $this->prescribeDetialsModel->select('PrescribeDetials.*, MedicineNames.MedicineName')
                    ->join('MedicineNames', 'PrescribeDetials.MedicineNameId = MedicineNames.id', 'left')
                    ->where('PrescribeDetials.ConsultationId', $consult['Id'])
                    ->findAll();
            }
            if (!empty($consultation)) {
                return $this
                    ->getApiResponse(
                        [
                            'statusCode' => 1,
                            'message' => "Prescription information has been fetched successfully.",
                            'data' => $consultation,
                        ]
                    );
            } else {
                return $this
                    ->getApiResponse(
                        [
                            'statusCode' => 1,
                            'message' => "There is no data.",
                        ]
                    );
            }
        } catch (Exception $e) {
            return $this->getApiResponse(
                [
                    'statusCode' => 3,
                    'message' => $e->getMessage()
                ],
            );
        }
    }


    // public function view()
    // {
    //     try {
    //         $rules = [
    //             'patientId' => 'required',
    //         ];
    //         $errors = [
    //             'patientId' => [
    //                 'required' => 'Patient id can not be empty.',
    //             ],
    //         ];
    //         $input = $this->getApiGetRequestInput($this->request);
    //         if (!$this->validateApiRequest($input, $rules, $errors)) {
    //             return $this
    //                 ->getApiResponse(
    //                     [
    //                         'statusCode' => 3,
    //                         'message' => array_values($this->validator->getErrors()),
    //                     ],
    //                 );
    //         }
    //         $result = $this->consultationsModel->select('consultations.*, PrescribeDetials.*, MedicineNames.MedicineName')
    //             ->join('PrescribeDetials', 'PrescribeDetials.ConsultationId = consultations.id', 'left')
    //             ->join('MedicineNames', 'PrescribeDetials.MedicineNameId = MedicineNames.id', 'left')
    //             ->where('consultations.PatientId', $input['patientId'])
    //             ->orderBy('consultations.ConsultationDate', 'desc')
    //             ->limit(2)
    //             ->findAll();
    //         // echo $this->webdocdb->getLastQuery(); exit;
    //         if (!empty($result)) {
    //             return $this
    //                 ->getApiResponse(
    //                     [
    //                         'statusCode' => 1,
    //                         'message' => "Prescription information has been fetched successfully.",
    //                         'data' => $result,
    //                     ]
    //                 );
    //         } else {
    //             return $this
    //                 ->getApiResponse(
    //                     [
    //                         'statusCode' => 1,
    //                         'message' => "There is no data.",
    //                     ]
    //                 );
    //         }
    //     } catch (Exception $e) {
    //         return $this->getApiResponse(
    //             [
    //                 'statusCode' => 3,
    //                 'message' => $e->getMessage()
    //             ],
    //         );
    //     }
    // }
}
