<?php

if (!function_exists('userId')) {
    function userId()
    {
        $user_id = getUserInfoFromJWTToken('user_id');
        return  $user_id;
    }
}

if (!function_exists('roleName')) {
    function roleName()
    {
        $role = getUserInfoFromJWTToken('role');
        return  $role;
    }
}

if (!function_exists('userEmail')) {
    function userEmail()
    {
        $email = getUserInfoFromJWTToken('user_email');
        return  $email;
    }
}

if (!function_exists('generateGUID')) {
    function generateGUID()
    {
        if (function_exists('com_create_guid') === true) {
            return trim(com_create_guid(), '{}');
        }

        return sprintf(
            '%04X%04X-%04X-%04X-%04X-%04X%04X%04X',
            mt_rand(0, 65535),
            mt_rand(0, 65535),
            mt_rand(0, 65535),
            mt_rand(16384, 20479),
            mt_rand(32768, 49151),
            mt_rand(0, 65535),
            mt_rand(0, 65535),
            mt_rand(0, 65535)
        );
    }
}

if (!function_exists('RSAencryption')) {
    function RSAencryption($data, $publicKeyString)
    {
        $publicKey = "-----BEGIN PUBLIC KEY-----\n" . $publicKeyString . "\n-----END PUBLIC KEY-----";
        $encryptedData = '';
        if (!openssl_public_encrypt($data, $encryptedData, $publicKey, OPENSSL_PKCS1_PADDING)) {
            throw new \Exception('Failed to encrypt data');
        }
        return base64_encode($encryptedData);
    }
}

if (!function_exists('RSADecryption')) {
    function RSADecryption($encryptedData, $publicKey)
    {
        $publicKey = "-----BEGIN PUBLIC KEY-----\n" . $publicKey . "\n-----END PUBLIC KEY-----";
        $decryptedData = '';
        if (!openssl_public_decrypt($encryptedData, $decryptedData, $publicKey, OPENSSL_PKCS1_PADDING)) {
            throw new \Exception('Failed to encrypt data');
        }
        return base64_encode($decryptedData);
    }
}

// if (!function_exists('TestRSADecryption')) {
//     function TestRSADecryption($encryptedData)
//     {
//         // Get Public Key content
//         $publicKey =
//             openssl_pkey_get_public(file_get_contents(base_url('assets/publicKeyHealthLine.pem')));

//             // print_r($publicKey); exit;
//         // Get tp_payload parameter from url
//         $encryptedData = isset($_GET['tp_payload']) ? $_GET['tp_payload'] : "";
//         // Define varialbe where the decrypted data will be stored
//         $decrypted = "";
//         // Decode using base 64
//         $encrypted = base64_decode($encryptedData);
//         // Decrypt Using PHP function
//         openssl_public_decrypt($encrypted, $decrypted, $publicKey);
//         // Print decrypted data
//         echo $decrypted; exit;
//     }
// }

if (!function_exists('traceNo')) {
    function traceNo()
    {
        return random_int(100000, 999999);
    }
}
