<?php

namespace App\Models;

use CodeIgniter\Model;

class RSAUsersModel extends Model
{
    protected $DBGroup          = 'rsadb';
    protected $table            = 'aspnetusers';
    protected $primaryKey       = 'Id';
    protected $useAutoIncrement = false;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
       'Id', 'Email', 'EmailConfirmed', 'NormalizedEmail', 'PasswordHash', 'SecurityStamp', 'ConcurrencyStamp', 'PhoneNumber', 'PhoneNumberConfirmed', 'TwoFactoreEnabled', 'LockoutEndDateUtc', 'LockoutEnabled', 'AccessFailedCount', 'UserName', 'NormalizedUserName'
    ];

    protected bool $allowEmptyInserts = false;

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];


     // Generate GUID before inserting
     protected function beforeInsert(array $data): array
     {
         $data['Id'] = $this->generateGUID();
         return $data;
     }
 
     // Function to generate GUID
     protected function generateGUID(): string
     {
         if (function_exists('com_create_guid') === true) {
             return trim(com_create_guid(), '{}');
         }
 
         return sprintf(
             '%04X%04X-%04X-%04X-%04X-%04X%04X%04X',
             mt_rand(0, 65535),
             mt_rand(0, 65535),
             mt_rand(0, 65535),
             mt_rand(16384, 20479),
             mt_rand(32768, 49151),
             mt_rand(0, 65535),
             mt_rand(0, 65535),
             mt_rand(0, 65535)
         );
     }
}
